///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ManBackupDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND DataBase_hWnd   = NULL;
    static HWND Driver_hWnd     = NULL;
    static HWND Server_hWnd     = NULL;
    static HWND UserID_hWnd     = NULL;
    static HWND UserPW_hWnd     = NULL;
    static HWND BackupFile_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        ManBackupDialog_hWnd = xHandle;

        SendMessage(ManBackupDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)"Manual Backup");
        SendMessage(ManBackupDialog_hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(100)) );

        Server_hWnd     = GetDlgItem(ManBackupDialog_hWnd, 1000);
        DataBase_hWnd   = GetDlgItem(ManBackupDialog_hWnd, 1001);
        Driver_hWnd     = GetDlgItem(ManBackupDialog_hWnd, 1002);
        UserID_hWnd     = GetDlgItem(ManBackupDialog_hWnd, 2000);
        UserPW_hWnd     = GetDlgItem(ManBackupDialog_hWnd, 2001);
        BackupFile_hWnd = GetDlgItem(ManBackupDialog_hWnd, 3000);

        Set_Text(Server_hWnd,     BackupServer);
        Set_Text(DataBase_hWnd,   BackupDataBase);
        Set_Text(Driver_hWnd,     BackupDriver);
        Set_Text(UserID_hWnd,     BackupUserID);
        Set_Text(UserPW_hWnd,     BackupUserPW);
        Set_Text(BackupFile_hWnd, BackupFile);

        if(BackupTrusted)
            CheckDlgButton(ManBackupDialog_hWnd, 2002, BST_CHECKED);

        CenterWindow(ManBackupDialog_hWnd);

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == 100) //- Okay (Dialog Command)
        {
            //--------------------------------------------------------
            char xDataBase[256];
            char xDriver[256];
            char xServer[256];
            char xUserID[256];
            char xUserPW[256];
            char xBackupFile[256];

            ClearMem(xDataBase, 256);
            ClearMem(xDriver, 256);
            ClearMem(xServer, 256);
            ClearMem(xUserID, 256);
            ClearMem(xUserPW, 256);
            ClearMem(xBackupFile, 256);

            Get_TextEx(DataBase_hWnd,   xDataBase,   256);
            Get_TextEx(Driver_hWnd,     xDriver,     256);
            Get_TextEx(Server_hWnd,     xServer,     256);
            Get_TextEx(UserID_hWnd,     xUserID,     256);
            Get_TextEx(UserPW_hWnd,     xUserPW,     256);
            Get_TextEx(BackupFile_hWnd, xBackupFile, 256);

            if( strlen(xDataBase) < 1)
            {
                MessageBox(ManBackupDialog_hWnd, "You must specify a database name.", TitleCaption, 0);
                return 0;
            }
            if( strlen(xDriver) < 1)
            {
                MessageBox(ManBackupDialog_hWnd, "You must specify a driver.", TitleCaption, 0);
                return 0;
            }
            if( strlen(xServer) < 1)
            {
                MessageBox(ManBackupDialog_hWnd, "You must specify a server name.", TitleCaption, 0);
                return 0;
            }
            if( strlen(xBackupFile) < 1)
            {
                MessageBox(ManBackupDialog_hWnd, "You must specify a backup file name.", TitleCaption, 0);
                return 0;
            }

            if(IsDlgButtonChecked(ManBackupDialog_hWnd, 2002))
            {
                SQLProcess.IsTrusted = TRUE;
                BackupTrusted = TRUE;
            }
            else{
                BackupTrusted = FALSE;
                SQLProcess.IsTrusted = FALSE;
            }

            CopyString(xDataBase,   SQLProcess.DataBase, strlen(xDataBase));
            CopyString(xDriver,     SQLProcess.Driver,   strlen(xDriver));
            CopyString(xServer,     SQLProcess.Server,   strlen(xServer));
            CopyString(xUserID,     SQLProcess.UserID,   strlen(xUserID));
            CopyString(xUserPW,     SQLProcess.UserPW,   strlen(xUserPW));

            CopyString(xDataBase,   BackupDataBase, strlen(xDataBase));
            CopyString(xDriver,     BackupDriver,   strlen(xDriver));
            CopyString(xServer,     BackupServer,   strlen(xServer));
            CopyString(xUserID,     BackupUserID,   strlen(xUserID));
            CopyString(xUserPW,     BackupUserPW,   strlen(xUserPW));
            CopyString(xBackupFile, BackupFile,     strlen(xBackupFile));

            //--------------------------------------------------------

            SetValues();

            RunningManual = TRUE;

            BackupJob(xBackupFile);

            EndDialog(ManBackupDialog_hWnd,0);
            DestroyWindow(ManBackupDialog_hWnd);

            return 0;
        }

        if(wParam == 101) //- Cancel (Dialog Command)
        {
            EndDialog(ManBackupDialog_hWnd,0);
            DestroyWindow(ManBackupDialog_hWnd);
            return 0;
        }

		if(wParam==102) //- Browse (Dialog Command)
		{
            char FileName[256];
            char *DefaultExtension = NULL;
            char *Filters = "SQL-Backup-File\0*.sbf\0\0";

            DWORD DialogType = OFD;
            DWORD Flags   = OFN_EXPLORER + OFN_LONGNAMES + OFN_PATHMUSTEXIST;

            Get_TextEx(BackupFile_hWnd, FileName, 256);

            if(OSFileDialog(ManBackupDialog_hWnd, FileName, DefaultExtension, TitleCaption, Filters, Get_CurrentDirectory(), SFD, Flags))
                Set_Text(BackupFile_hWnd, FileName);

			return 0;
		}

		if(wParam==103) //- Select database (Dialog Command)
		{
            JID.Dialog_hWnd = ManBackupDialog_hWnd;
            JID.Database_hWnd = DataBase_hWnd;
        	DialogBox(MainInstance, MAKEINTRESOURCE(109), ManBackupDialog_hWnd, SelectDBDialog);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(ManBackupDialog_hWnd,0);
        DestroyWindow(ManBackupDialog_hWnd);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

